<?php
/* --------------------------------------------------------------
   CronjobsOverviewController.inc.php 2018-08-27
   Gambio GmbH
   http://www.gambio.de
   Copyright © 2018 Gambio GmbH
   --------------------------------------------------------------
*/

class CronjobsOverviewController extends AdminHttpViewController
{
    /**
     * @var \LanguageTextManager
     */
    protected $languageTextManager;
    
    /**
     * @var \NonEmptyStringType
     */
    protected $title;
    
    /**
     * @var \ExistingFile
     */
    protected $template;
    
    
    /**
     * Initialize Controller
     */
    public function init()
    {
        $this->languageTextManager = MainFactory::create('LanguageTextManager', 'cronjobs', $_SESSION['languages_id']);
        $this->title               = new NonEmptyStringType($this->languageTextManager->get_text('title'));
        $this->template            = new ExistingFile(new NonEmptyStringType(DIR_FS_ADMIN
                                                                             . '/html/content/cronjobs/overview.html'));
    }
    
    
    /**
     * Renders the cronjob configuration ui.
     *
     * @return \HttpControllerResponseInterface
     */
    public function actionDefault()
    {
        $assets = MainFactory::create('AssetCollection');
        $assets->add(MainFactory::create('Asset', 'admin_buttons.lang.inc.php'));
        $assets->add(MainFactory::create('Asset', 'cronjobs.lang.inc.php'));
        $assets->add(MainFactory::create('Asset', 'cronjob_check_permissions.lang.inc.php'));
        $assets->add(MainFactory::create('Asset', 'cronjob_delete_guest_accounts.lang.inc.php'));
        $assets->add(MainFactory::create('Asset', 'cronjob_delete_logs.lang.inc.php'));
        $assets->add(MainFactory::create('Asset', 'cronjob_create_sitemap.lang.inc.php'));
        $assets->add(MainFactory::create('Asset', 'cronjob_image_processing.lang.inc.php'));
        
        return MainFactory::create('AdminLayoutHttpControllerResponse', $this->title, $this->template, null, $assets);
    }
}